#define CLIP(a) if (a > 32767) a = 32767; if (a < -32768) a = -32768;

typedef struct
{
	char hbppGarbage[16]; 		// 14 bytes of HB++ header + 2 bytes for padding
	long samplerate;					// private lSRate           as Long 'Intel order
	long instantaneous_phase;	// private lInstPhase       as Long 'Intel order
	long phase;								// private lPhase           as Long 'Intel order
	short * sine_table;				// private lSineTablePtr    as Long 'Intel order
	short lfo_mod;						// private iLFOMod          as Integer 'Intel order
	short lfo_rate;						// private iLFOrate         as Integer 'Intel order
	long lfo_phase;						// private lLFOPhase        as Long
}
callback_params;

unsigned int audio_callback(void * userPtr, long streamId, void * buffer_ptr, long frames)
{
	int i, j,k;
	short 					* 	p 										= (short *)buffer_ptr;
  callback_params *		prms									= (callback_params *) userPtr;
  
  for (i = 0; i < frames; i++)
  	{
  		long R,L;
  		long x1, x2, sine, lfo;
  		short int_part, dec_part;
  		
  		// increment LFO phase
  		prms->lfo_phase += prms->lfo_rate;
  		
  		// wrap LFO phase
  		prms->lfo_phase = prms->lfo_phase & ((1 << 20) - 1);
  		
  		// compute lfo value and modulate
  		lfo = prms->sine_table[prms->lfo_phase >> 10];
  		lfo = (lfo * prms->lfo_mod) >> 16;
  		
  		// increment phase, instantaneous phase is modulated by LFO
  		prms->phase += ((128 + lfo) * prms->instantaneous_phase) >> 7;
  		
  		// wrap phase
  		prms->phase = prms->phase & ((1 << 24) - 1);
  		
  		// get lookup table indices from phase
  		int_part = prms->phase >> 14;
  		dec_part = prms->phase & ((1 << 14) - 1);
  		
  		// interpolate
  		x1 = prms->sine_table[int_part];
  		x2 = prms->sine_table[int_part+1];
  		sine = x1 + (((x2-x1) * dec_part) >> 14);
  		
  		// Mixing and panning should be done here
  		L = sine;
  		R = sine;
  		
  		// Clip the long before writing to buffer
  		CLIP(L)
  		CLIP(R)
  		
  		// Write to buffer
  		*p++ = L;
  		*p++ = R;
  	}
  return 0;
}